"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var PageItemInput_exports = {};
__export(PageItemInput_exports, {
  PageItemInput: () => PageItemInput
});
module.exports = __toCommonJS(PageItemInput_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var import_react = require("react");
var import_events = require("../../context/events");
var import_TldrawUiInput = require("../primitives/TldrawUiInput");
const PageItemInput = function PageItemInput2({
  name,
  id,
  isCurrentPage
}) {
  const editor = (0, import_editor.useEditor)();
  const trackEvent = (0, import_events.useUiEvents)();
  const rInput = (0, import_react.useRef)(null);
  const handleFocus = (0, import_react.useCallback)(() => {
    editor.mark("rename page");
  }, [editor]);
  const handleChange = (0, import_react.useCallback)(
    (value) => {
      editor.renamePage(id, value || "New Page");
      trackEvent("rename-page", { source: "page-menu" });
    },
    [editor, id, trackEvent]
  );
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_TldrawUiInput.TldrawUiInput,
    {
      className: "tlui-page-menu__item__input",
      ref: (el) => rInput.current = el,
      defaultValue: name,
      onValueChange: handleChange,
      onFocus: handleFocus,
      shouldManuallyMaintainScrollPositionWhenFocused: true,
      autoFocus: isCurrentPage,
      autoSelect: true
    }
  );
};
//# sourceMappingURL=PageItemInput.js.map
